import { ModuleWithProviders } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';

import { HomepageComponent } from './core/homepage/homepage.component';
import { SearchComponent } from './core/search/search.component';

import { NotFoundComponent } from './core/not-found/not-found.component';

const routes: Routes = [
  { path: '', component: HomepageComponent},
  { path: 'search/:val', component: SearchComponent },
  { path: 'common', loadChildren: 'app/mccf-common/mccf-common.module#MccfCommonModule'},
  { path: 'epayments', loadChildren: 'app/mccf-epayment/mccf-epayment.module#MccfEpaymentModule'},
  { path: 'epharmacy', loadChildren: 'app/mccf-epharmacy/mccf-epharmacy.module#MccfEpharmacyModule'},
  { path: 'einsurance', loadChildren: 'app/mccf-einsurance/mccf-einsurance.module#MccfEinsuranceModule'},
  { path: 'ebilling', loadChildren: 'app/mccf-ebilling/mccf-ebilling.module#MccfEbillingModule'},
  { path: 'non-mccf', loadChildren: 'app/mccf-non-mccf/mccf-non-mccf.module#NonMccfModule'},
  { path: 'eadmin', loadChildren: 'app/mccf-eadmin/mccf-eadmin.module#MccfEadminModule'},
  { path: 'npi', loadChildren: 'app/mccf-npi/mccf-npi.module#MccfNpiModule'},
  { path: '**', component: NotFoundComponent }
];

export const routing: ModuleWithProviders = RouterModule.forRoot(routes);
